ORCA/M Asm65816 2.1.0

0001 BE70                       title 'PictureDefProc' 
0002 BE70              **********************************************************************
0003 BE70              *
0004 BE70              * Picture Control Def Proc
0005 BE70              *
0006 BE70              *
0007 BE70              * Copyright (C)
0008 BE70              * Apple Computer, Inc.  1986-1989
0009 BE70              * All Rights Reserved
0010 BE70              *
0011 BE70              * 23 Sep 88         Steven Glass
0012 BE70              *
0013 BE70              * Coding begin from modified version of the statText custom control
0014 BE70              * which came from Tech Support's custom control (by Keith Rollin).
0015 BE70              *
0016 BE70              * 06 NOv 88         Steven Glass
0017 BE70              *
0018 BE70              * Allow for default rect calculation in do_init.
0019 BE70              *
0020 BE70              * 28 mar 89         Steven Glass
0021 BE70              *
0022 BE70              * Changed init routine to use standard descriptors for Picture Ref.
0023 BE70              *
0024 BE70              * Added support for CtlWinStateChange message.  This defProc ignores
0025 BE70              * it since pictures look the same in inactive and active windows.
0026 BE70              *
0027 BE70              * 15 May 89         Steven Glass
0028 BE70              *
0029 BE70              * Changed jsr to LoadResource to _CMLoadResource so can segment this
0030 BE70              * proc.
0031 BE70              *
0032 BE70              * Released the resource when control is killed!!!!
0033 BE70              *
0034 BE70              **********************************************************************
0035 BE70
0036 BE70                       blanks off 
0037 BE70                       string asis 
0038 BE70
0039 BE70                       print push 
0040 BE70                       print off 
0041 BE70
0042 BE70                       include 'all.macros' 
0043 BE70                       include 'm16.util2' 
0044 BE70                       include 'm16.memory' 
0045 BE70                       include 'm16.quickdraw' 
0046 BE70                       include 'm16.qdaux' 
0047 BE70                       include 'm16.control' 
0048 BE70                       include 'm16.window' 
0049 BE70                       include 'm16.resources' 
0050 BE70
0051 BE70                       include 'CtlCustomEqus.asm' 
0052 BE70                       include 'e16.quickdraw' 
0053 BE70                       include 'e16.font' 
0054 BE70                       include 'e16.resources' 
0055 BE70
0056 BE70
0057 BE70
0058 BE70                       print pop 
0059 BE70
0060 BE70              ;-----------------------------------------------------------
0061 BE70              ;
0062 BE70              ; Stack Fram Equates for control
0063 BE70              ;
0064 BE70                       DefineStack 
0065 BE70              OrigD    WORD                           ; caller's saved direct page register
0066 BE70              OrigB    byte                           ; caller's saved data bank register
0067 BE70              CtlPtr   LONG                           ; pointer to control record
0068 BE70              RtnAddr  block 3                        ; RTL address back to Control Manager
0069 BE70              theCtlHandle LONG                       ; handle to control record
0070 BE70              CtlParam LONG                           ; add'l parameter passed to DefProc
0071 BE70              CtlCode  WORD                           ; operation to perform
0072 BE70              ReturnValue LONG                        ; space for return value to Ctl Mgr.
0073 BE70
0074 BE70
0075 BE70
0076 BE70
0077 BE70
0078 BE70                       title 'PictureDefProc -- MainEntry' 
0079 BE70
0080 BE70              ****************************************************************
0081 BE70              *
0082 BE70              PicProc  PROC EXPORT 
0083 BE70              *
0084 BE70              * This is the def_proc for picture controls.  When this
0085 BE70              * routine gets control, the stack looks as described below.
0086 BE70              *
0087 BE70              *
0088 BE70              *
0089 BE70              * Inputs:           On entry, the parameters are passed to us on the stack.
0090 BE70              *
0091 BE70              *                   |                   | Previous Contents
0092 BE70              *                   |-------------------|
0093 BE70              *                   |    ReturnValue    | LONG - Space for return value
0094 BE70              *                   |-------------------|
0095 BE70              *                   |    CtlCode        | WORD - operation to perform
0096 BE70              *                   |-------------------|
0097 BE70              *                   |    CtlParam       | LONG - add'l parameter
0098 BE70              *                   |-------------------|
0099 BE70              *                   |    theCtlHandle   | LONG - Handle to control record
0100 BE70              *                   |-------------------|
0101 BE70              *                   |    RtnAddr        | 3 BYTES - RTL address
0102 BE70              *                   |-------------------|
0103 BE70              *                   |                   | <-- Stack pointer
0104 BE70              *
0105 BE70              * Outputs:          Put something into ReturnValue, pull off the parameters,
0106 BE70              *                   and return to the Control Manager.
0107 BE70              *
0108 BE70              *                   |                   | Previous Contents
0109 BE70              *                   |-------------------|
0110 BE70              *                   |    ReturnValue    | LONG - Space for return value
0111 BE70              *                   |-------------------|
0112 BE70              *                   |    RtnAddr        | 3 BYTES - RTL address
0113 BE70              *                   |-------------------|
0114 BE70              *                   |                   | <-- Stack pointer
0115 BE70              *
0116 BE70              * External Refs:
0117 BE70                       import do_draw 
0118 BE70                       import do_nothing 
0119 BE70                       import do_test 
0120 BE70                       import do_init 
0121 BE70                       import do_recsize 
0122 BE70              *
0123 BE70              * Entry Points:
0124 BE70              *                   none
0125 BE70              *
0126 BE70                       longa on                       ; mode
0127 BE70                       longi on
0128 BE70              *
0129 BE70              ****************************************************************
0130 BE70
0131 BE70 48                    pha                            ; push on some room for 'CtlPtr'
0132 BE71 48                    pha   
0133 BE72
0134 BE72 8B                    phb                            ; save the Data Bank register
0135 BE73 0B                    phd                            ; save the Direct Page register
0136 BE74
0137 BE74 4B                    phk                            ; switch data bank to program bank
0138 BE75 AB                    plb   
0139 BE76 3B                    tsc                            ; switch Direct Page into stack
0140 BE77 5B                    tcd   
0141 BE78
0142 BE78 A5 13                 lda   <CtlCode
0143 BE7A C9 0C 00              cmp   #recSize
0144 BE7D F0 0B                 beq   SkipDeref
0145 BE7F
0146 BE7F A7 0B                 lda   [<theCtlHandle]
0147 BE81 85 04                 sta   <CtlPtr
0148 BE83 A0 02 00              ldy   #2
0149 BE86 B7 0B                 lda   [<theCtlHandle],y
0150 BE88 85 06                 sta   <CtlPtr+2
0151 BE8A
0152 BE8A              SkipDeref  
0153 BE8A A5 13                 lda   <CtlCode                 ; get routine # to call
0154 BE8C C9 14 00              cmp   #ctlWinStateChange+1     ; make sure msg is in range 
0155 BE8F 90 03                 blt   ShiftIt
0156 BE91 A9 06 00              lda   #6                       ; force unknown codes to null events
0157 BE94              ShiftIt   
0158 BE94 0A                    asl   a
0159 BE95 AA                    tax   
0160 BE96 FC AE BE              jsr   (ActionTable,x)
0161 BE99
0162 BE99 85 15                 sta   <ReturnValue             ; save the return value
0163 BE9B 86 17                 stx   <ReturnValue+2
0164 BE9D
0165 BE9D              ;
0166 BE9D              ; The Return Value has been stored on the stack, and it is time for us to
0167 BE9D              ; return back to the Control Manager. Before we do so, however, we must
0168 BE9D              ; remove the parameters that were passed to us on the stack. We do this
0169 BE9D              ; by moving the RTL address up just below the Return Value, getting the
0170 BE9D              ; stack pointer, and adding an amount to it so that we point to where
0171 BE9D              ; the RTL address has been moved to. We can then simply RTL back to the
0172 BE9D              ; Control Manager, and it will pick up the Return Value right off of the
0173 BE9D              ; stack!
0174 BE9D              ;
0175 BE9D A5 08                 lda   <RtnAddr                 ; move the return address up
0176 BE9F 85 12                 sta   <ReturnValue-3
0177 BEA1 A5 09                 lda   <RtnAddr+1
0178 BEA3 85 13                 sta   <ReturnValue-2
0179 BEA5
0180 BEA5 3B                    tsc                            ; Get the stack pointer
0181 BEA6
0182 BEA6 2B                    pld                            ; restore caller's Data Bank and
0183 BEA7 AB                    plb                            ; Direct Page registers
0184 BEA8
0185 BEA8 18                    clc                            ; Adjust the stack pointer to point to
0186 BEA9 69 11 00              adc   #ReturnValue-4           ; the new location of the RTL address.
0187 BEAC 1B                    tcs                            ; Put the stack pointer back.
0188 BEAD
0189 BEAD 6B                    rtl                            ; back to the caller
0190 BEAE
0191 BEAE
0192 BEAE              ;
0193 BEAE 4F BF        ActionTable DC W:do_draw                0 Draw simple button.
0194 BEB0 DD BE                 DC W:do_nothing                1 Compute drag RECT.
0195 BEB2 48 BF                 DC W:do_test                   2 Common hit test routine.
0196 BEB4 E2 BE                 DC W:do_init                   3 Initialize the control.
0197 BEB6 DD BE                 DC W:do_nothing                4 Dispose.
0198 BEB8 4F BF                 DC W:do_draw                   5 New value.
0199 BEBA DD BE                 DC W:do_nothing                6 Compute Thumber constrains.
0200 BEBC DD BE                 DC W:do_nothing                7 Drag the indicator.
0201 BEBE DD BE                 DC W:do_nothing                8 Auto action.
0202 BEC0 4F BF                 DC W:do_draw                   9 New value.
0203 BEC2 DD BE                 DC W:do_nothing                10 Set min max.
0204 BEC4 DD BE                 DC W:do_nothing                11 Move button.
0205 BEC6 D6 BE                 DC W:do_recsize                12 Return size of standard record.
0206 BEC8 DD BE                 DC W:do_nothing                13 take key or menu event
0207 BECA DD BE                 DC W:do_nothing                14 ctlChangeTarget
0208 BECC DD BE                 DC W:do_nothing                15 ctlChagneBounds
0209 BECE DD BE                 DC W:do_nothing                16 ctlWindChagneSize
0210 BED0 DD BE                 DC W:do_nothing                17 ctlHandleTab
0211 BED2 DD BE                 DC W:do_nothing                18 ctlNotifyMultiPart
0212 BED4 DD BE                 DC W:do_nothing                19 ctlWinStateChange (Pic Ctls do not redraw)
0213 BED6                       ENDP 
0214 BED6
0215 BED6
0216 BED6                       title 'PictureDefProc -- do_recsize' 
0217 BED6              ****************************************************************
0218 BED6              *
0219 BED6              do_recsize PROC 
0220 BED6              *
0221 BED6              * Returns the size of the control record.
0222 BED6              *
0223 BED6              *
0224 BED6              * Inputs:
0225 BED6              *                   none
0226 BED6              *
0227 BED6              * Outputs:
0228 BED6              *                   a-reg & x-reg hold result for def proc
0229 BED6              *
0230 BED6              * External Refs:
0231 BED6              *                   none
0232 BED6              *
0233 BED6              * Entry Points:
0234 BED6              *                   none
0235 BED6              *
0236 BED6                       longa on                       ; mode
0237 BED6                       longi on
0238 BED6              *
0239 BED6              ****************************************************************
0240 BED6
0241 BED6
0242 BED6 A9 40 00              lda   #superCtlSize
0243 BED9 A2 00 00              ldx   #0                       High word of size.
0244 BEDC
0245 BEDC 60                    rts   
0246 BEDD
0247 BEDD                       ENDP 
0248 BEDD
0249 BEDD
0250 BEDD                       title 'PictureDefProc -- Do_Nothing' 
0251 BEDD              ****************************************************************
0252 BEDD              *
0253 BEDD              do_nothing PROC 
0254 BEDD              *
0255 BEDD              * This is the routine we use when there is nothing to do.
0256 BEDD              * It just returns zeros in the a and x registers.
0257 BEDD              *
0258 BEDD              *
0259 BEDD              * Inputs:
0260 BEDD              *                   ctlHandle
0261 BEDD              *                   ctlPtr
0262 BEDD              *
0263 BEDD              * Outputs:
0264 BEDD              *                   a-reg & x-reg hold result for def proc
0265 BEDD              *
0266 BEDD              * External Refs:
0267 BEDD              *                   none
0268 BEDD              *
0269 BEDD              * Entry Points:
0270 BEDD              *                   none
0271 BEDD              *
0272 BEDD                       longa on                       ; mode
0273 BEDD                       longi on
0274 BEDD              *
0275 BEDD              ****************************************************************
0276 BEDD
0277 BEDD              ;
0278 BEDD A9 00 00              lda   #0                       Nothing flag.
0279 BEE0 AA                    tax   
0280 BEE1
0281 BEE1 60                    rts   
0282 BEE2
0283 BEE2                       ENDP 
0284 BEE2
0285 BEE2
0286 BEE2                       title 'PictureDefProc -- Do_Init' 
0287 BEE2              ****************************************************************
0288 BEE2              *
0289 BEE2              do_init  PROC 
0290 BEE2              *
0291 BEE2              * Inits fields in the control record based on the values in
0292 BEE2              * in the control template.
0293 BEE2              *
0294 BEE2              * The ctlData field is set to be a pointer to the static text
0295 BEE2              * and the ctlValue field is set to be the size of the static
0296 BEE2              * text field (from the value in the template).
0297 BEE2              *
0298 BEE2              *
0299 BEE2              * Inputs:
0300 BEE2              *                   ctlHandle
0301 BEE2              *                   ctlPtr
0302 BEE2              *                   ctlParam = ptr to template
0303 BEE2              *
0304 BEE2              * Outputs:
0305 BEE2              *                   a-reg and x-reg are zero.
0306 BEE2              *
0307 BEE2              * External Refs:
0308 BEE2                       import PushCtlData 
0309 BEE2                       import ConvertToHandle 
0310 BEE2              *
0311 BEE2              * Entry Points:
0312 BEE2              *                   none
0313 BEE2              *
0314 BEE2                       longa on                       ; mode
0315 BEE2                       longi on
0316 BEE2              *
0317 BEE2              * Change History
0318 BEE2              *
0319 BEE2              * 06 Nov 88         Steven Glass
0320 BEE2              *
0321 BEE2              * If the control rect is has 0 for bottom, we calculate
0322 BEE2              * the rect using the frame rect in the picture.  This will give
0323 BEE2              * us a rect that has no scaling.
0324 BEE2              *
0325 BEE2              ****************************************************************
0326 BEE2
0327 BEE2
0328 BEE2 A0 1C 00              ldy   #PictureTemplate.PicRef+2
0329 BEE5 B7 0F                 lda   [<ctlParam],y
0330 BEE7 AA                    tax   
0331 BEE8 88                    dey   
0332 BEE9 88                    dey   
0333 BEEA B7 0F                 lda   [<ctlParam],y
0334 BEEC A0 1C 00              ldy   #NewCtlRecord.ctlData
0335 BEEF 97 04                 sta   [<ctlPtr],y
0336 BEF1 C8                    iny   
0337 BEF2 C8                    iny   
0338 BEF3 8A                    txa   
0339 BEF4 97 04                 sta   [<ctlPtr],y
0340 BEF6
0341 BEF6
0342 BEF6 A0 0C 00              ldy   #NewCtlRecord.ctlRect+4
0343 BEF9 B7 04                 lda   [ctlPtr],y
0344 BEFB D0 46                 bne   RectIsComplete
0345 BEFD
0346 BEFD 48                    pha                            ; space for result
0347 BEFE 48                    pha   
0348 BEFF
0349 BEFF 20 71 BF              jsr   PushCtlData              ; push ref on stack
0350 BF02
0351 BF02 20 7F BF              jsr   ConvertToHandle          ; turn ref into handle (if not already)
0352 BF05
0353 BF05
0354 BF05 68                    pla                            ; deref the picture handle in ctlParam
0355 BF06 85 0F                 sta   ctlParam
0356 BF08 68                    pla   
0357 BF09 85 11                 sta   ctlParam+2
0358 BF0B A7 0F                 lda   [ctlParam]
0359 BF0D AA                    tax   
0360 BF0E A0 02 00              ldy   #2
0361 BF11 B7 0F                 lda   [ctlParam],y
0362 BF13 85 11                 sta   ctlParam+2
0363 BF15 86 0F                 stx   ctlParam
0364 BF17
0365 BF17 A0 06 00              ldy   #6                       ; height of frame rect is bottom-top
0366 BF1A B7 0F                 lda   [ctlParam],y
0367 BF1C 38                    sec   
0368 BF1D A0 02 00              ldy   #2
0369 BF20 F7 0F                 sbc   [ctlParam],y
0370 BF22 18                    clc   
0371 BF23 A0 08 00              ldy   #NewCtlRecord.ctlRect    ; add to control rect top
0372 BF26 77 04                 adc   [ctlPtr],y
0373 BF28 A0 0C 00              ldy   #NewCtlRecord.ctlRect+4
0374 BF2B 97 04                 sta   [ctlPtr],y
0375 BF2D
0376 BF2D A0 08 00              ldy   #8                       ; width of frame rect is left-right
0377 BF30 B7 0F                 lda   [ctlParam],y
0378 BF32 38                    sec   
0379 BF33 A0 04 00              ldy   #4
0380 BF36 F7 0F                 sbc   [ctlParam],y
0381 BF38 18                    clc   
0382 BF39 A0 0A 00              ldy   #NewCtlRecord.ctlRect+2  ; add to control rect left to get right
0383 BF3C 77 04                 adc   [ctlPtr],y
0384 BF3E A0 0E 00              ldy   #NewCtlRecord.ctlRect+6
0385 BF41 97 04                 sta   [ctlPtr],y
0386 BF43              RectIsComplete  
0387 BF43
0388 BF43 A9 00 00              lda   #0
0389 BF46 AA                    tax   
0390 BF47 60                    rts   
0391 BF48
0392 BF48
0393 BF48
0394 BF48                       ENDP 
0395 BF48
0396 BF48
0397 BF48                       title 'PictureDefProc -- do_test' 
0398 BF48              ****************************************************************
0399 BF48              *
0400 BF48              do_test  PROC 
0401 BF48              *
0402 BF48              * Test if the mouse is down in the control.  We always
0403 BF48              * return no, since it does not make sense to "click" on
0404 BF48              * static text.
0405 BF48              *
0406 BF48              *
0407 BF48              * Inputs:
0408 BF48              *                   ctlParam = point to check
0409 BF48              *
0410 BF48              *
0411 BF48              * Outputs:
0412 BF48              *                   a-reg and x-reg are always zero
0413 BF48              *
0414 BF48              * External Refs:
0415 BF48              *                   none
0416 BF48              *
0417 BF48              * Entry Points:
0418 BF48              *                   none
0419 BF48              *
0420 BF48                       longa on                       ; mode
0421 BF48                       longi on
0422 BF48              *
0423 BF48              ****************************************************************
0424 BF48
0425 BF48
0426 BF48 A9 00 00              lda   #0                       Never return a part code
0427 BF4B A2 00 00              ldx   #0
0428 BF4E
0429 BF4E 60                    rts   
0430 BF4F
0431 BF4F                       ENDP 
0432 BF4F
0433 BF4F
0434 BF4F                       title 'PictureDefProc -- Do_Draw' 
0435 BF4F              ****************************************************************
0436 BF4F              *
0437 BF4F              do_draw  PROC 
0438 BF4F              *
0439 BF4F              * Draws the control using DrawPicture.
0440 BF4F              *
0441 BF4F              *
0442 BF4F              * Inputs:
0443 BF4F              *                   ctlHandle
0444 BF4F              *                   ctlPtr
0445 BF4F              *
0446 BF4F              * Outputs:
0447 BF4F              *                   a-reg and x-reg are zero.
0448 BF4F              *
0449 BF4F              * External Refs:
0450 BF4F              *                   none
0451 BF4F              *
0452 BF4F              * Entry Points:
0453 BF4F                       ENTRY PushCtlData 
0454 BF4F                       ENTRY ConvertToHandle 
0455 BF4F              *
0456 BF4F                       longa on                       ; mode
0457 BF4F                       longi on
0458 BF4F              *
0459 BF4F              * Change History
0460 BF4F              *
0461 BF4F              * 28 Mar 89         Steven Glass
0462 BF4F              *
0463 BF4F              * Changed definitions of moreFlags bits so that low two bits
0464 BF4F              * are used like all other controls: 0 = ptr, 1 = handle, 2 =
0465 BF4F              * resource.
0466 BF4F              *
0467 BF4F              * Docs will state that 0 is invalid.
0468 BF4F              *
0469 BF4F              ****************************************************************
0470 BF4F
0471 BF4F 48                    pha                            ; space for result
0472 BF50 48                    pha   
0473 BF51
0474 BF51 20 71 BF              jsr   PushCtlData              ; push ref on stack
0475 BF54
0476 BF54 20 7F BF              jsr   ConvertToHandle          ; turn ref into handle (if not already)
0477 BF57
0478 BF57 A5 04                 lda   ctlPtr                   ; point to control rect
0479 BF59 18                    clc   
0480 BF5A 69 08 00              adc   #NewCtlRecord.ctlRect
0481 BF5D AA                    tax   
0482 BF5E A5 06                 lda   ctlPtr+2
0483 BF60 69 00 00              adc   #0
0484 BF63 48                    pha   
0485 BF64 DA                    phx   
0486 BF65
0487 BF65 A2 04 BA 22           _DrawPicture 
0488 BF6C
0489 BF6C
0490 BF6C A9 00 00              lda   #0
0491 BF6F AA                    tax   
0492 BF70 60                    rts   
0493 BF71
0494 BF71
0495 BF71              PushCtlData  
0496 BF71 FA                    plx   
0497 BF72 A0 1E 00              ldy   #NewCtlRecord.ctlData+2
0498 BF75 B7 04                 lda   [ctlPtr],y
0499 BF77 48                    pha   
0500 BF78 88                    dey   
0501 BF79 88                    dey   
0502 BF7A B7 04                 lda   [ctlPtr],y
0503 BF7C 48                    pha   
0504 BF7D DA                    phx   
0505 BF7E 60                    rts   
0506 BF7F
0507 BF7F
0508 BF7F              ;-----------------------------------------------------------
0509 BF7F              ;
0510 BF7F              ; Looks at the more flags to see what the data value holds.
0511 BF7F              ; The low 2 bits of the flag indicate:
0512 BF7F              ;
0513 BF7F              ;     0  undefined
0514 BF7F              ;     1  handle
0515 BF7F              ;     2  resource
0516 BF7F              ;
0517 BF7F              ConvertToHandle  
0518 BF7F A0 3C 00              ldy   #NewCtlRecord.ctlMoreFlags
0519 BF82 B7 04                 lda   [ctlPtr],y
0520 BF84 29 03 00              and   #$0003                   ; only care about low 2 bits
0521 BF87 C9 01 00              cmp   #1                       ;(RefIsHandle)      ; If not handle, it must be resource
0522 BF8A F0 1B                 beq   AlreadyHandle
0523 BF8C
0524 BF8C
0525 BF8C A3 03                 lda   3,s
0526 BF8E AA                    tax   
0527 BF8F A3 05                 lda   5,s
0528 BF91 48                    pha   
0529 BF92 48                    pha   
0530 BF93 F4 02 80              PushWord #rPicture 
0531 BF96 48                    pha   
0532 BF97 DA                    phx   
0533 BF98 20 9C 9D              jsr   LoadResource
0534 BF9B 68                    pla   
0535 BF9C 7A                    ply   
0536 BF9D
0537 BF9D FA                    plx   
0538 BF9E 83 05                 sta   5,s
0539 BFA0 98                    tya   
0540 BFA1 83 07                 sta   7,s
0541 BFA3 68                    pla   
0542 BFA4 68                    pla   
0543 BFA5 DA                    phx   
0544 BFA6 60                    rts   
0545 BFA7
0546 BFA7
0547 BFA7 FA           AlreadyHandle plx   
0548 BFA8 A3 01                 lda   1,s
0549 BFAA 83 05                 sta   5,s
0550 BFAC A3 03                 lda   3,s
0551 BFAE 83 07                 sta   7,s
0552 BFB0 68                    pla   
0553 BFB1 68                    pla   
0554 BFB2 DA                    phx   
0555 BFB3 18                    clc   
0556 BFB4 60                    rts   
0557 BFB5
0558 BFB5
0559 BFB5                       ENDP 
0560 BFB5
0561 BFB5
0562 BFB5
0563 BFB5                       END   
